/*
 ******************************************************************************
 * $Id: vx_uuid.h,v 1.13 2007/12/20 07:25:44 svadapal Exp $
 * $Source: /src/apps/uuid/code/api/include/vx_uuid.h,v $
 * $Copyright: Copyright (c) 2008 Symantec Corporation.
 * All rights reserved.
 *
 * THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF
 * SYMANTEC CORPORATION.  USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED
 * WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
 *
 * The Licensed Software and Documentation are deemed to be commercial
 * computer software as defined in FAR 12.212 and subject to restricted
 * rights as defined in FAR Section 52.227-19 "Commercial Computer
 * Software - Restricted Rights" and DFARS 227.7202, "Rights in
 * Commercial Computer Software or Commercial Computer Software
 * Documentation", as applicable, and any successor regulations. Any use,
 * modification, reproduction release, performance, display or disclosure
 * of the Licensed Software and Documentation by the U.S. Government
 * shall be solely in accordance with the terms of this Agreement.  $
 ******************************************************************************
 */

#ifndef _VX_UUID_H_
#define _VX_UUID_H_


#include <stdlib.h>
#include <vx_error.h>
#include <vx_av_macros.h>

#ifdef __cplusplus
extern "C" {
#endif


#ifdef UNIX
#ifdef __cplusplus
    #define EXTERN_C    extern "C"
#else
    #define EXTERN_C
#endif
#endif

#define VXHID_MAX_NAMESPACE_SZ		11
#define VX_MAX_STRING_SZ			1024
#define HMAC_LEN					20
#define  VX_TRUE					1
#define  VX_FALSE					0

typedef struct  _os_uuid_t
{
    unsigned int   Data1;
    unsigned short Data2;
    unsigned short Data3;
    unsigned char  Data4[8];
} os_uuid_t;

typedef struct  _host_uuid_t
{
    char	hid_namespace[VXHID_MAX_NAMESPACE_SZ];
    size_t	hid_identifier_sz;
    char	hid_identifier[1];	/* variable length */
} host_uuid_t;


typedef void *         uuid_handle_t;

/*Version info*/
typedef struct _uuid_versioninfo
{
  unsigned int   major;
  unsigned int   minor;
} uuid_versioninfo_t;

/*
 * Attribute values types are described by the following enumeration.
 * The value within '' in the comment is the XML meta-attribute type
 * value. The numeric value is also acceptable.
 */
typedef enum {
	UUID_AVT_INVALID        = -2, /* 'X' - invalid type */
	UUID_AVT_NONE           = -1, /* '' - no attribute value present */
	UUID_AVT_STRING         = 0,  /* 's' - 7 bit ASCII */
	UUID_AVT_INT            = 1,  /* 'i32' or 'i' - 32 bit */
	UUID_AVT_UINT           = 2,  /* 'u32' or 'u' - 32 bit */ 
	UUID_AVT_INT64          = 3,  /* 'i64' - 64 bit */
	UUID_AVT_UINT64         = 4,  /* 'u64' - 64 bit */ 
	UUID_AVT_BOOLEAN        = 5,  /* 'b' */
	UUID_AVT_TIME           = 6,  /* 't' - XML: "YYYYMMDDhhmmss" (UTC) */
	UUID_AVT_DURATION       = 7,  /* 'd' - time duration in sec (32bit)*/
	UUID_AVT_UTF8		  = 8,  /* 'U' - UCS-4 stream format */
	UUID_AVT_OBJECT	  = 9,  /* 'h' - Object handle */
#define	UUID_AVT_HANDLE  UUID_AVT_OBJECT /* old alias */
	UUID_AVT_ERROR          = 10, /* 'e' */
	UUID_AVT_POINTER        = 11 /* In-proc - no OTW representation */
} uuid_attribute_value_type_t;

/* System general data types, integer types and DLL declarations */
#ifdef _WIN32
#include <windows.h>
#include <time.h>
typedef signed int       uuid_int32_t;
typedef unsigned int     uuid_uint32_t;
typedef signed __int64   uuid_int64_t;
typedef unsigned __int64 uuid_uint64_t;
#define VRTSAZ_DLL_EXTERN_DECL __declspec( dllimport )
#else /* !_WIN32 */
#include <sys/types.h>
#include <inttypes.h>
typedef int32_t  uuid_int32_t;
typedef uint32_t uuid_uint32_t;
#ifdef _HPUX_64_UNDEFINED
typedef signed long long   uuid_int64_t;
typedef unsigned long long uuid_uint64_t;
#else
typedef int64_t  uuid_int64_t;
typedef uint64_t uuid_uint64_t;
#endif
#define VRTSAZ_DLL_EXTERN_DECL extern
#endif /* !_WIN32 */


/* Binary state type */
typedef enum { UUID_FALSE = 0, UUID_TRUE = 1 } uuid_boolean_t;

/* UTF-8 C string (null terminated) */
typedef char * uuid_utf8_t;

/* 7 bit ASCII C string (null terminated) */
typedef char * uuid_string_t;

/* The following type is used to hold a time duration measured in seconds.
 * It is a 32 bit number, that may be added to a time_t data type.
 * The time_t data type itself may be 32/64 bit, depending on the platform
 * and environment.
 */
typedef uuid_int32_t uuid_time_duration_t;

/* The following type is used to hold a buffer of arbitrary data */
typedef struct {
	void *bytes;
	size_t len;
} uuid_data_t;

/*
 * Attribute value pairs are handled through the following
 * data structure.
 */
typedef struct {
	uuid_string_t av_name; /* attribute name */
	uuid_attribute_value_type_t av_type; /* type in union below */
	union {
		uuid_string_t av_string; /* 7 bit ASCII C string */
		uuid_int32_t av_int; /* 32 bit integer value */
		uuid_uint32_t av_uint; /* 32 bit unsigned integer value */
		uuid_int64_t av_int64; /* 64 bit integer value */
		uuid_uint64_t av_uint64; /* 64 bit unsigned integer value */
		uuid_boolean_t av_boolean; /* boolean */
		time_t av_time; /* absolute time */
		uuid_time_duration_t av_duration; /* relative time */
		uuid_utf8_t av_utf8; /* UTF-8 C string */
		vxerror av_error; /* error code */
		uuid_data_t av_data; /* reserved */

		/* in-memory only */
		void *av_pointer; /* arbitrary C pointer */

	} av_u; /* attribute value union - type to use defined in avtype */
} uuid_attribute_t;


#ifndef WIN32
#define VRTS_UUID_API 
#else
#define VRTS_UUID_API __cdecl 
#endif


/*
vxerror VRTS_UUID_API uuid_initialize(
               uuid_versioninfo_t        *version,
               uuid_handle_t             *handle);
*/

vxerror VRTS_UUID_API uuid_initialize(
               const uuid_attribute_t	 inAttrs[],
			   size_t					 numAttrs,	
               uuid_handle_t             *handle);

vxerror VRTS_UUID_API uuid_terminate(
               uuid_handle_t             handle);


vxerror VRTS_UUID_API create_os_uuid(
				uuid_handle_t		handle,
				os_uuid_t**			osuuid,
				int					resetFlag);

vxerror VRTS_UUID_API get_os_uuid_str_new(
				uuid_handle_t		handle, 
				char**				osuuidStr,
				size_t*				osuuidStrLen);

vxerror VRTS_UUID_API get_os_uuid(
				uuid_handle_t		handle,
				os_uuid_t**			osuuid);


vxerror VRTS_UUID_API get_os_uuid_str(
				uuid_handle_t		handle,
				char**				osuuidStr,
				size_t*				osuuidStrLen);

vxerror VRTS_UUID_API os_uuid_to_string(
				uuid_handle_t		handle,
				os_uuid_t*			osuuid,	
				char**				osuuidStr,
				size_t*				osuuidStrLen);

vxerror VRTS_UUID_API create_host_uuid(
				uuid_handle_t		handle,
				host_uuid_t**		hostuuid,
				int					resetFlag);

vxerror VRTS_UUID_API get_host_uuid_str(
				uuid_handle_t		handle,
				char**				osuuidStr,
				size_t*				osuuidStrLen);

vxerror VRTS_UUID_API uuid_free(
				uuid_handle_t		handle,
				void*				data);

	
#ifdef __cplusplus
}
#endif
#endif


