/*
 * $Id: vx_av_macros.h,v 1.2 2006/04/11 21:03:16 mvohra1 Exp $
 * $Source: /src/apps/uuid/code/api/include/vx_av_macros.h,v $
 * $Copyright: Copyright (c) 2008 Symantec Corporation.
 * All rights reserved.
 *
 * THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF
 * SYMANTEC CORPORATION.  USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED
 * WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
 *
 * The Licensed Software and Documentation are deemed to be commercial
 * computer software as defined in FAR 12.212 and subject to restricted
 * rights as defined in FAR Section 52.227-19 "Commercial Computer
 * Software - Restricted Rights" and DFARS 227.7202, "Rights in
 * Commercial Computer Software or Commercial Computer Software
 * Documentation", as applicable, and any successor regulations. Any use,
 * modification, reproduction release, performance, display or disclosure
 * of the Licensed Software and Documentation by the U.S. Government
 * shall be solely in accordance with the terms of this Agreement.  $
 *
 */
#ifndef UUID_AV_MACROS_H
#define UUID_AV_MACROS_H

/* macro to de-reference specific fields in the array */
#define UUID_AV_NAME(_av,_n) _av[_n].av_name
#define UUID_AV_TYPE(_av,_n) _av[_n].av_type
#define UUID_AV_VALUE(_av,_n,_field) _av[_n].av_u.av_##_field

/* macro to set the name of an attribute in the array called "av" using
 * "n" as the index.
 * The index may be safely pre/post-incremented.
 */
#define UUID_AV_SET_NAME(_av,_n,_attr)	\
	_av[_n].av_name = _attr;

/* Macro to set attributes in the array called "av" using "n" as the index 
 * The index may be safely pre/post-incremented.
 */
#define _UUID_AV_SET_VALUE(_av,_n,_attr,_avt,_field,_value) \
	{ size_t __n = (_n);                               \
	_av[__n].av_name = _attr;			   \
	_av[__n].av_type = UUID_AVT_##_avt;      	   \
	_av[__n].av_u.av_##_field = _value;	 	   \
	}

#define UUID_AV_SET_NONE(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,NONE,int,0)

#define UUID_AV_SET_STRING(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,STRING,string,_value)

#define UUID_AV_SET_OBJECT(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,OBJECT,object,_value)

#define UUID_AV_SET_HANDLE(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,HANDLE,handle,_value)

#define UUID_AV_SET_CLASS_NAME(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,CLASS_NAME,class_name,_value)

#define UUID_AV_SET_INSTANCE_NAME(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,INSTANCE_NAME,instance_name,_value)

#define UUID_AV_SET_TIME(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,TIME,time,_value)

#define UUID_AV_SET_INT(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,INT,int,_value)

#define UUID_AV_SET_UINT(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,UINT,uint,_value)

#define UUID_AV_SET_INT64(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,INT64,int64,_value)

#define UUID_AV_SET_UINT64(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,UINT64,uint64,_value)

#define UUID_AV_SET_BOOLEAN(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,BOOLEAN,boolean,_value)

#define UUID_AV_SET_ERROR(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,ERROR,error,_value)

#define UUID_AV_SET_DURATION(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,DURATION,duration,_value)

#define UUID_AV_SET_POINTER(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,POINTER,pointer,(void *)_value)

#define UUID_AV_SET_OBJECT(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,OBJECT,object,_value)

#define UUID_AV_SET_UTF8(_av,_n,_attr,_value) \
	_UUID_AV_SET_VALUE(_av,_n,_attr,UTF8,utf8,_value)


#endif /* UUID_AV_MACROS_H */
