# $Copyright: Copyright (c) 2009 Symantec Corporation.
# All rights reserved.
#
# THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF
# SYMANTEC CORPORATION.  USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED
# WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
#
# The Licensed Software and Documentation are deemed to be commercial
# computer software as defined in FAR 12.212 and subject to restricted
# rights as defined in FAR Section 52.227-19 "Commercial Computer
# Software - Restricted Rights" and DFARS 227.7202, "Rights in
# Commercial Computer Software or Commercial Computer Software
# Documentation", as applicable, and any successor regulations. Any use,
# modification, reproduction release, performance, display or disclosure
# of the Licensed Software and Documentation by the U.S. Government
# shall be solely in accordance with the terms of this Agreement.  $
##$Source: /src/apps/eat2/Authentication/gui/src/runvssatgui.sh.src,v $
##$Id: runvssatgui.sh.src,v 1.2.2.2 2007/10/26 22:53:23 varwade Exp $
# 

PKGNAME=VRTSat

if [ -z "$EAT_HOME_DIR" -a -f "/etc/vx/vss/${PKGNAME}.loc" ] ; then
    echo "warning: environment variable EAT_HOME_DIR is not set, will attempt to use the shared AT instead."
    if [ -s /etc/vx/vss/${PKGNAME}.loc ] ; then
        echo "Authentication Subsystem has been installed"
        ATINSTALLDIR=`grep ProductInstallDir /etc/vx/vss/${PKGNAME}.loc | sed 's/ProductInstallDir=//'`
        CLASSPATH=$CLASSPATH:${ATINSTALLDIR}:${ATINSTALLDIR}/lib/AtWrapper.jar:${ATINSTALLDIR}/lib/vssatgui.jar:${ATINSTALLDIR}/lib/VxHelpViewer.jar:${ATINSTALLDIR}/lib/VxHelpViewerl10n.jar
    else
        echo "Authentication Subsystem has not been installed"
        exit 1
    fi
else
    if [ -z "$EAT_HOME_DIR" ] ; then
        echo "error: environment variable EAT_HOME_DIR is not set, unable to run AT gui."
        exit 1
    else
        ATINSTALLDIR=$EAT_HOME_DIR
        CLASSPATH=$CLASSPATH:${ATINSTALLDIR}:${ATINSTALLDIR}/lib/AtWrapper.jar:${ATINSTALLDIR}/lib/vssatgui.jar:${ATINSTALLDIR}/lib/VxHelpViewer.jar:${ATINSTALLDIR}/lib/VxHelpViewerl10n.jar
    fi
fi

if [ -s /etc/vx/vss/VRTSaz.loc ]
then
echo "Authorization Subsystem has been installed"
AZINSTALLDIR=`grep ProductInstallDir /etc/vx/vss/VRTSaz.loc | sed 's/ProductInstallDir=//'`
CLASSPATH=$CLASSPATH:${AZINSTALLDIR}:${AZINSTALLDIR}/lib/AzWrapper.jar:${AZINSTALLDIR}/lib/vssazgui.jar
else
echo "Authorization Subsystem has not been installed"
fi
echo "CLASSPATH is $CLASSPATH"
export CLASSPATH

uname=`uname -m`
osname=`uname -s`
if [ -z "$EAT_HOME_DIR" ] ; then
	java  -Dvrtsat.libpath=${ATINSTALLDIR}/lib/ vrts.vss.gui.ui.Vssgui
else
	java  -Dvrtsat.libpath=${ATINSTALLDIR}/lib vrts.vss.gui.ui.Vssgui
fi

