# $Copyright: Copyright (c) 2009 Symantec Corporation.
# All rights reserved.
#
# THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF
# SYMANTEC CORPORATION.  USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED
# WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
#
# The Licensed Software and Documentation are deemed to be commercial
# computer software as defined in FAR 12.212 and subject to restricted
# rights as defined in FAR Section 52.227-19 "Commercial Computer
# Software - Restricted Rights" and DFARS 227.7202, "Rights in
# Commercial Computer Software or Commercial Computer Software
# Documentation", as applicable, and any successor regulations. Any use,
# modification, reproduction release, performance, display or disclosure
# of the Licensed Software and Documentation by the U.S. Government
# shall be solely in accordance with the terms of this Agreement.  $
## $Source: /src/apps/eat2/Authentication/packaging/BOB/postinstall.sh,v $
## $Id: postinstall.sh,v 1.2.2.7 2008/04/25 06:20:59 varwade Exp $


#!/bin/sh

_create_profiles () {
  if [ ! -d $PKG_INSTALL_ROOT/var/VRTSat ]; then
    mkdir $PKG_INSTALL_ROOT/var/VRTSat
  fi
  chmod 755 $PKG_INSTALL_ROOT/var/VRTSat > $PKG_INSTALL_ROOT/dev/null 2>&1
  (cd $PKG_INSTALL_ROOT/var/VRTSat; mkdir profiles > $PKG_INSTALL_ROOT/dev/null 2>&1; chmod 1777 profiles)
}

_create_lhc () {
  #Create or change perms on VRTSat_lhc.
  $EAT_HOME_DIR/bin/vssregctl -f"$PKG_INSTALL_ROOT/etc/vx/vss/VRTSat.conf" -s -b"Security\\Authentication\\Credential Manager" -k"LHCDirectory" -v "/var/VRTSat_lhc" -t string

  if [ ! -d $PKG_INSTALL_ROOT/var/VRTSat_lhc ]; then
    mkdir -m 1777 $PKG_INSTALL_ROOT/var/VRTSat_lhc
  else
    chown root $PKG_INSTALL_ROOT/var/VRTSat_lhc
    chmod 1777 $PKG_INSTALL_ROOT/var/VRTSat_lhc
  fi
}

_populate_systruststore () {
  # Create the systruststore if its not there
  if [ ! -d $PKG_INSTALL_ROOT/var/VRTSat/.VRTSat/profile/systruststore ]; then
    mkdir -p $PKG_INSTALL_ROOT/var/VRTSat/.VRTSat/profile/systruststore
  fi
  
  # Make it world readable
  chmod 744 $PKG_INSTALL_ROOT/var/VRTSat/.VRTSat/profile/systruststore
  
  # Copy the trusted credentials from /var/VRTSat/.VRTSat/profile/certstore/trusted to systruststore
  if [ -d $PKG_INSTALL_ROOT/var/VRTSat/.VRTSat/profile/certstore/trusted ]; then
     cp -f $PKG_INSTALL_ROOT/var/VRTSat/.VRTSat/profile/certstore/trusted/*.* $PKG_INSTALL_ROOT/var/VRTSat/.VRTSat/profile/systruststore 2>/dev/null
  fi
}

_set_lib_perms()
{
    # try all the lib extensions. 

	chmod 755 $EAT_HOME_DIR/lib/libauth*.so 2>/dev/null
	chmod 755 $EAT_HOME_DIR/lib/libvrtsat*.so 2>/dev/null
	chmod 755 $EAT_HOME_DIR/lib/libAtWrapper.so 2>/dev/null

	# This is required for HP-UX.
	chmod 755 $EAT_HOME_DIR/lib/libauth*.sl 2>/dev/null
	chmod 755 $EAT_HOME_DIR/lib/libvrtsat*.sl 2>/dev/null
	chmod 755 $EAT_HOME_DIR/lib/libAtWrapper.sl 2>/dev/null
}

_set_eat_dir()
{
  # Read EAT_HOME_DIR, EAT_DATA_DIR and set it in vssat script

  if [ $# -ne 2 ]; then
      echo "_set_eat_dir: Invalid Input. Requires two args. got "$#
      return 1;
  fi

  eat_var=$1
  eat_val=$2

  if [ ! -z "$EAT_HOME_DIR" ]; then
    VSSAT_FILE=$EAT_HOME_DIR/bin/vssat
    if [ -f "$VSSAT_FILE" ]; then
      TMP=/tmp/$$
      rm $TMP > /dev/null 2>&1
      var=`cat $VSSAT_FILE | grep "^\#$eat_var="`
      if [ $? = 0 ]; then
        sed -e "s|$var|$eat_var=$eat_val|" $VSSAT_FILE > $TMP
        found=1
      else
        var=`cat $VSSAT_FILE | grep "^$eat_var="`
        if [ $? = 0 ]; then
          sed -e "s|$var|$eat_var=$eat_val|" $VSSAT_FILE > $TMP
          found=1
        fi
      fi
      if [ "$found" = 1 ]; then
        mv $TMP $VSSAT_FILE
        chmod +x $VSSAT_FILE
      fi
    fi
  fi
}

_create_profiles
_create_lhc
_populate_systruststore
_set_lib_perms
if [ ! -z "$EAT_HOME_DIR" ]; then
   _set_eat_dir EAT_HOME_DIR $EAT_HOME_DIR
fi
if [ ! -z "$EAT_DATA_DIR" ]; then
   _set_eat_dir EAT_DATA_DIR $EAT_DATA_DIR
fi
if [ ! -z "$EAT_CATALOG_DIR" ]; then
   _set_eat_dir EAT_CATALOG_DIR $EAT_CATALOG_DIR
fi


